#!/usr/bin/perl
###############################################################################
# Copyright 2009-2018, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
use strict;
use Fcntl qw(:DEFAULT :flock);
use IPC::Open3;

sysopen (my $CHKSERVD, "/etc/chkserv.d/chkservd.conf", O_RDWR | O_CREAT);
flock ($CHKSERVD, LOCK_EX);
my @chkservd = <$CHKSERVD>;
chomp @chkservd;

if (not grep {$_ =~ /^osmd/} @chkservd) {
	open (OUT,">/etc/chkserv.d/osmd");
	print OUT "service[osmd]=x,x,x,service osmd restart,osmd,root\n";
	close (OUT);

	seek ($CHKSERVD, 0, 0);
	truncate ($CHKSERVD, 0);
	foreach my $line (@chkservd) {print $CHKSERVD "$line\n"}
	print $CHKSERVD "osmd:1\n";
}
close ($CHKSERVD);
